Imports EJRandomOrgConsumer.StructuresAndEnums
Imports System.ComponentModel

Public Class BaseGenerator


    Private _ConnectionTimeout As Integer = 10000
    Private _RandomizationMethod As RandomizationMethods = RandomizationMethods.Random
    Private _RandomizationIdentifier As String = ""
    Private _RandomizationDate As Date = DateAdd(DateInterval.Day, -1, Now())


#Region " Properties "


    ''' <summary>
    ''' Gets or sets the the amount of time, in milliseconds, that must elapse before a request is considered timed-out.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(True), DefaultValue(10000), Description("Gets or sets the the amount of time, in milliseconds, that must elapse before a request is considered timed-out.")> _
    Public Property ConnectionTimeout() As Integer
        Get
            Return _ConnectionTimeout
        End Get
        Set(ByVal value As Integer)
            If value <= 0 Then
                Throw New Exception("The connection timeout must be a positive integer.")
            Else
                _ConnectionTimeout = value
            End If
        End Set
    End Property


    ''' <summary>
    ''' Gets or sets the method randomization used when generating a random number.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(True), DefaultValue(GetType(RandomizationMethods), "Random"), Description("Gets or sets the method randomization used when generating a random number.")> _
    Public Property RandomizationMethod() As RandomizationMethods
        Get
            Return _RandomizationMethod
        End Get
        Set(ByVal value As RandomizationMethods)
            _RandomizationMethod = value
        End Set
    End Property


    ''' <summary>
    ''' Gets or sets the identifier to use when the RandomizationMethod property is set to RandomizationMethods.IdentifierBased.
    ''' This property is ignored for other randomization methods.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(True), DefaultValue(""), Description("Gets or sets the identifier to use when the RandomizationMethod property is set to RandomizationMethods.IdentifierBased.  This property is ignored for other randomization methods.")> _
    Public Property RandomizationIdentifier() As String
        Get
            Return _RandomizationIdentifier
        End Get
        Set(ByVal value As String)
            _RandomizationIdentifier = value
        End Set
    End Property


    ''' <summary>
    ''' Gets or sets the date to use when the RandomizationMethod property is set to RandomizationMethods.DateBased.
    ''' This property is ignored for other randomization methods.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(True), Description("Gets or sets the date to use when the RandomizationMethod property is set to RandomizationMethods.DateBased.  This property is ignored for other randomization methods.")> _
    Public Property RandomizationDate() As Date
        Get
            Return _RandomizationDate
        End Get
        Set(ByVal value As Date)
            _RandomizationDate = value
        End Set
    End Property


#End Region


    Public Sub New()

    End Sub


    Public Overridable Sub Dispose()

    End Sub


End Class
